<?php

namespace App\Http\Controllers;

use App\Utility\SetupWizard\SetupWizard;
use App\Http\Requests\DatabaseConfigRequest;
use App\Http\Requests\ProfileUpdateRequest;
use App\Models\User;
use Hash;
use Exception;

class SetupController extends Controller
{
    private $setup_wizard;

    public function __construct() {
        $this->setup_wizard = new SetupWizard();
    }

    public function index() {
        $requirements = $this->setup_wizard->get_setup_requirements();
        return view('setup.step_1', compact('requirements'));
    }

    public function database($status) {
        return view('setup.step_2', compact('status'));
    }

    public function setup_database(DatabaseConfigRequest $request) {
        $host     = $request->hostname;
        $database = $request->database;
        $username = $request->username;
        $password = $request->password;

        if ($this->setup_wizard->create_db_tables($host, $database, $username, $password) == false) {
            return redirect()->back()->with("error", "Invalid Database Settings");
        }
        
        return redirect()->route('setup.migrations');    
    }

    public function migrations() { 
        if($this->setup_wizard->run_migrations()) {
            return redirect()->route('setup.database','proceed')->with("success", "Database configured and Migrations executed successfully, You can safely proceed to the next step.");    
        } else {
            return redirect()->route('setup.database','create')->with("error", "Failed to execute the Migrations, Please try again.");
        }
    }

    public function user() { 
        $user = User::first();
        return view('setup.step_3', compact('user'));
    }

    public function create_user(ProfileUpdateRequest $request, User $user) {
        try {
            $user->name = $request->name;
            $user->email = $request->email;
            $user->password = Hash::make($request->password);
            $user->save();
            
            $this->setup_wizard->finish_setup();

            return redirect()->to('/');
        } catch (Exception $e) {
            return redirect()->back()->with('error', 'Something went wrong please try again.');
        }  
    }
}
